import yaml from 'yaml';
import * as fs from 'fs';
import * as process from 'process';

const defaultConfig = {
  host: '::',
  port: 3000,
  DB_HOST: 'localhost',
  DB_PORT: 5432,
  DB_USER: 'mycard',
  DB_PASS: 'mycard',
  DB_NAME: 'mycard',
  WX_ID: '',
  WX_SECRET: '',
  WX_TOKEN: '',
  WX_AESKEY: '',
  CDB_REPO: 'https://code.mycard.moe/mycard/ygopro-database.git',
  CDB_BRANCH: 'master',
  FEEDBACK_NOTIFY_URL: '',
  FEEDBACK_NOTIFY_TOKEN: 'default',
  REDIS_URL: 'redis://localhost:6379',
  ROOT_URL:
    process.env.NODE_ENV === 'production'
      ? 'https://jdaw.moecube.com'
      : 'http://localhost:3000',
};

export type Config = typeof defaultConfig;

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
    ...process.env,
  };
}
