import { Injectable, OnApplicationBootstrap } from '@nestjs/common';
import { InjectContext } from 'koishi-nestjs';
import { Context } from 'koishi';
import { TemplateService } from '../template/template.service';

@Injectable()
export class ReplyService implements OnApplicationBootstrap {
  constructor(
    @InjectContext() private ctx: Context,
    private template: TemplateService,
  ) {}
  onApplicationBootstrap() {
    const base = this.ctx.command('reply', '默认回复。');
    for (const templateName of this.template
      .getTemplateList()
      .filter((t) => t.startsWith('reply-'))) {
      const commandName = templateName.slice(6);
      base.subcommand(`.${commandName}`).action(() => {
        return this.template.render(templateName, {});
      });
    }
  }
}
