import { ConsoleLogger, Injectable } from '@nestjs/common';
import { UseEvent } from 'koishi-nestjs';
import { Session } from 'koishi';
import { TemplateService } from '../template/template.service';

@Injectable()
export class OnSubscribeService extends ConsoleLogger {
  constructor(private template: TemplateService) {
    super('OnSubscribeService');
  }
  @UseEvent('wechat:subscribe')
  async onSubscribe(session: Session) {
    this.log(`User ${session.userId} subscribed.`);
    await session.send(this.template.render('on-subscribe'));
  }

  @UseEvent('wechat:unsubscribe')
  async onUnsubscribe(session: Session) {
    this.log(`User ${session.userId} unsubscribed.`);
  }
}
