import { Entity, SelectQueryBuilder } from 'typeorm';
import { UserBase } from '../../utility/user-base.entity';
import {
  applyQueryProperty,
  applyQueryPropertySearch,
  StringColumn,
} from 'nicot';

@Entity()
export class Feedback extends UserBase {
  @StringColumn(50, { required: true, description: '反馈类型' })
  category: string;

  @StringColumn(10000, { required: true, description: '反馈内容' })
  content: string;

  applyQuery(qb: SelectQueryBuilder<Feedback>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryProperty(this, qb, entityName, 'category');
    applyQueryPropertySearch(this, qb, entityName, 'content');
  }

  toNotifyText() {
    return `收到 ${this.userId} 的 ${this.category} 反馈:\n${this.content}`;
  }
}
