import { Entity, Index, SelectQueryBuilder } from 'typeorm';
import { applyQueryProperty, StringColumn } from 'nicot';
import { Argv } from 'koishi';
import { UserBase } from '../../utility/user-base.entity';

@Entity()
export class CommandCount extends UserBase {
  @Index()
  @StringColumn(64, { required: true, description: '命令' })
  command: string;

  fromArgv(argv: Argv) {
    this.command = argv.command.name;
    return this.fromSession(argv.session);
  }

  applyQuery(qb: SelectQueryBuilder<CommandCount>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryProperty(this, qb, entityName, 'command');
  }
}
