import { Injectable } from '@nestjs/common';
import { CrudService } from 'nicot';
import { CommandCount } from './entities/command-count.entity';
import { Repository } from 'typeorm';
import { InjectRepository } from '@nestjs/typeorm';
import { UseEvent } from 'koishi-nestjs';
import { Argv } from 'koishi';

@Injectable()
export class CommandCountService extends CrudService(CommandCount) {
  constructor(@InjectRepository(CommandCount) repo: Repository<CommandCount>) {
    super(repo);
  }

  @UseEvent('command/before-execute')
  async onCommand(argv: Argv) {
    this.log.log(
      `User ${argv.session.userId} executed command ${argv.command.name}`,
    );
    const record = new CommandCount().fromArgv(argv);
    await this.create(record);
  }
}
