import { Injectable } from '@nestjs/common';
import { PutUserId, UseCommand } from 'koishi-nestjs';
import { TemplateService } from '../template/template.service';
import { HttpService } from '@nestjs/axios';
import { MycardAuthService } from 'nestjs-mycard';
import { MycardAccountService } from '../mycard-account/mycard-account.service';
import { lastValueFrom } from 'rxjs';

@Injectable()
export class ArenaScoreService {
  constructor(
    private template: TemplateService,
    private http: HttpService,
    private mycard: MycardAuthService,
    private mycardAccount: MycardAccountService,
  ) {}
  @UseCommand('arena-score', '查询 MyCard 匹配战绩')
  async arenaScoreCommand(@PutUserId() id: string) {
    const user = await this.mycardAccount.findOrCreateUser(id);
    if (!user.mycardId) {
      return (
        '您还未绑定 MyCard 帐号。' + (await this.mycardAccount.bind(id, true))
      );
    }
    const mycardUser = await this.mycard.getUser(user.mycardId);
    const result = await lastValueFrom(
      this.http.get('https://sapi.moecube.com:444/ygopro/arena/user', {
        params: {
          username: mycardUser.username,
        },
      }),
    );
    return this.template.render('arena-score', {
      ...result.data,
      name: mycardUser.username,
    });
  }
}
