import { IsBase64, IsString, MaxLength, MinLength } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class BindQueryDto {
  @IsBase64()
  @IsString()
  @ApiProperty({ description: 'MyCard SSO' })
  sso: string;
  @IsString()
  @MaxLength(64)
  @MinLength(64)
  @ApiProperty({ description: 'session ID' })
  session: string;

  decodeToken() {
    const decoded = Buffer.from(this.sso, 'base64').toString();
    const params = new URLSearchParams(decoded);
    return params.get('token');
  }
}
