import { Injectable, OnApplicationBootstrap } from '@nestjs/common';
import { WireContextService } from 'koishi-nestjs';
import WechatBot from 'koishi-plugin-adapter-wechat-official';

@Injectable()
export class BotService implements OnApplicationBootstrap {
  @WireContextService()
  private bots: WechatBot[];

  getBot() {
    return this.bots[0];
  }

  private builtinCommands = new Set<string>();

  onApplicationBootstrap() {
    this.getBot()
      .config.menus.flatMap((menu) =>
        menu.children.map((child) => child.command),
      )
      .filter((command) => command)
      .forEach((command) => this.builtinCommands.add(command));
  }

  isBuiltinCommand(command: string) {
    return this.builtinCommands.has(command);
  }
}
