import {
  Controller,
  Get,
  Header,
  Query,
  Render,
  ValidationPipe,
} from '@nestjs/common';
import { MycardAccountService } from './mycard-account.service';
import { ApiOperation, ApiProduces } from '@nestjs/swagger';
import { BindQueryDto } from './dto/bind-query.dto';
import { TemplateService } from '../template/template.service';

@Controller('mycard-account')
export class MycardAccountController {
  constructor(
    private mycardAccountService: MycardAccountService,
    private template: TemplateService,
  ) {}

  @Get('bind')
  @ApiOperation({
    summary: '绑定帐号回调。',
  })
  @ApiProduces('text/html')
  @Header('content-type', 'text/html')
  @Header('cache-control', 'no-cache')
  async bind(
    @Query(
      new ValidationPipe({
        transform: true,
        transformOptions: { enableImplicitConversion: true },
      }),
    )
    dto: BindQueryDto,
  ) {
    const view = await this.mycardAccountService.bindCallback(dto);
    return this.template.render('bind-result.html', view, true);
  }
}
