import { NestFactory } from '@nestjs/core';
import { SwaggerModule, DocumentBuilder } from '@nestjs/swagger';
import { NestExpressApplication } from '@nestjs/platform-express';
import { AppModule } from './app.module';
import { ConfigService } from '@nestjs/config';
import { KoishiWsAdapter } from 'koishi-nestjs';

async function bootstrap() {
  const app = await NestFactory.create<NestExpressApplication>(AppModule);
  app.setGlobalPrefix('api');
  app.useWebSocketAdapter(new KoishiWsAdapter(app));
  app.enableCors();
  if (process.env.NODE_ENV !== 'production') {
    app.enableCors();
  }
  app.set('trust proxy', ['172.16.0.0/12', 'loopback']);

  const documentConfig = new DocumentBuilder()
    .setTitle('jdaw')
    .setDescription('决斗暗网')
    .setVersion('1.0.0')
    .build();

  const document = SwaggerModule.createDocument(app, documentConfig);
  SwaggerModule.setup('docs', app, document);

  const config = app.get(ConfigService);
  await app.listen(
    config.get<number>('port') || 3000,
    config.get<string>('host') || '::',
  );
}
bootstrap();
