import mt19937 from '@stdlib/random-base-mt19937';
import ip from 'ipaddr.js';

export function hashAddress(cidr: string, token: string) {
  const [range, prefixLength] = ip.parseCIDR(cidr);
  const rand = mt19937.factory({
    seed: Buffer.from(token || 'default', 'utf-8').toJSON().data,
  });
  let remaining = (range.kind() === 'ipv6' ? 128 : 32) - prefixLength;
  const buffer = range.toByteArray();
  for (let i = buffer.length - 1; i >= 0; i--) {
    if (remaining < 8) {
      const lastPart = (buffer[i] >> remaining) << remaining;
      const randomPart = rand() % (1 << (1 + remaining));
      buffer[i] = lastPart | randomPart;
      break;
    }
    buffer[i] = rand() % 256;
    remaining -= 8;
  }
  return ip.fromByteArray(buffer);
}
