YATS: Yet Another TypeScript Syntax
===================================

[![Build Status](https://travis-ci.org/HerringtonDarkholme/yats.vim.svg?branch=master)](https://travis-ci.org/HerringtonDarkholme/yats.vim)

![screenshot](https://raw.githubusercontent.com/HerringtonDarkholme/yats.vim/master/screenshot.png)

Yet Another TypeScript Syntax file for Vim, adapted from [YAJS](https://github.com/othree/yajs.vim).
Key differences:

* Exuberant Highlighting. The most elaborate or byzatine syntax highlighting for TypeScript.
* Bundled with snippets for UltiSnips!
* Builtin Support for tagbar!
* Use 'typescript' as group name's prefix, not 'typeScript' nor 'TypeScript'. Works great with [SyntaxComplete](https://github.com/vim-scripts/SyntaxComplete).
* Inherit Web API and DOM keywords from YAJS
* Syntax fold. Fold long code block, semantically!
* Remove old, unused syntax definitions.

Config
----
* `let g:yats_host_keyword = 1`: configure yats to highlight host specific keywords like `addEventListener`. Default is 1. Set it 0 to turn off highlighting.

* Note: `set re=1` explicitly in your vimrc. Old regexp engine will incur performance issues for yats and old engine is usually turned on by other plugins.

Credits
-------

- [othree](https://github.com/othree), whose YAJS is the most up-to-date js syntax for Vim
- Jose Elera, [Enhanced Javascript syntax](http://www.vim.org/scripts/script.php?script_id=3425)
- Zhao Yi, Claudio Fleiner, Scott Shattuck (This file is based on their hard work)
- gumnos (From the #vim IRC Channel in Freenode) (Who helped me figured out the crazy Vim Regexes)

License
-------

The same as Vim

