#!/bin/bash
set -o errexit
RACADM=/opt/dell/srvadmin/sbin/racadm

# CERT_PATH
# IDRAC_HOST
# IDRAC_USER
# IDRAC_PASS
fullChain="$CERT_PATH/fullchain.pem"
privKey="$CERT_PATH/privkey.pem"

echo "Checking certificates on $IDRAC_HOST..."

certSerial="$(openssl x509 -in $fullChain -noout -serial | cut -d= -f2)"
echo "Cert serial: $certSerial"
idracSerial="$($RACADM -r $IDRAC_HOST -u $IDRAC_USER -p $IDRAC_PASS sslcertview -t 1 | grep 'Serial Number' | awk '{print $6}')"
echo "IDRAC serial: $idracSerial"

if [[ "$certSerial" == "$idracSerial" ]]; then
  echo "Cert is same, skipping."
  exit 0
fi

echo "Updating cert on $IDRAC_HOST..."

$RACADM -r $IDRAC_HOST -u $IDRAC_USER -p $IDRAC_PASS sslkeyupload -t 1 -f $privKey
$RACADM -r $IDRAC_HOST -u $IDRAC_USER -p $IDRAC_PASS sslcertupload -t 1 -f $fullChain
$RACADM -r $IDRAC_HOST -u $IDRAC_USER -p $IDRAC_PASS racreset

echo "Done."
