# Genesys lflist.conf Generator

This project provides a Python script (`main.py`) that generates a **Genesys-format `lflist.conf`** for YGOPro/EDOPro.  
It combines the official Genesys point list (from Konami’s website) with the card database (`cards.cdb`).

---

## Features

- Parse Genesys HTML table (Card Name / Points).
- Match card names to `cards.cdb`:
  - First try **absolute match** (exact English name).
  - Fallback to **normalized match** (remove non-alphanumeric characters, lowercase).
- Disable all **Link** and **Pendulum** monsters.
- Output in the new `$slot`-style `lflist.conf` format:

```
#[Genesys TCG]
# Genernated by genesys-gen
!Genesys TCG

$genesys 100

# Genesys points
<card_id> $genesys <points> -- <English name>

# Disable Pendulum and Link monsters
<card_id> 0
```

---

## Requirements

- **Python 3.10+**
- No external dependencies. Only Python standard library modules are used.

---

## Important Notes

- You **must** use the **English version** of `cards.cdb`.  
  Otherwise, card names will not match the Genesys list correctly.

---

## Preparing Resources

```
# Download the Genesys point list (HTML)
wget -O genesys.html https://www.yugioh-card.com/en/genesys/

# Download the English card database
wget -O cards.cdb https://cdntx.moecube.com/koishipro/ygopro-database/en-US/cards.cdb
```

---

## Usage

```
python3 main.py \
  --html genesys.html \
  --cdb cards.cdb \
  --out lflist.conf \
  --cap 100
```

Arguments:
- `--html` : Path to the Genesys HTML file (default: `genesys.html`).
- `--cdb`  : Path to the `cards.cdb` database (English version).
- `--out`  : Output path for the generated `lflist.conf`.
- `--cap`  : Genesys point cap (default = 100).

---

## Output

- A new `lflist.conf` will be written at the location specified by `--out`.
- Any unmatched cards (name mismatch) will be listed at the end of the file in comments:

```
# --- Unmatched cards (by name) ---
# [UNMATCHED] Example Card -> 50  (normalized: examplecard)
```

---

## Example

```
python3 main.py --html genesys.html --cdb cards.cdb --out lflist.conf
```

Output sample:

```
#[Genesys TCG]
# Genernated by genesys-gen
!Genesys TCG

$genesys 100

# Genesys points
12345678 $genesys 50 -- Example Card

# Disable Pendulum and Link monsters
34567890 0
```

## Pre-built download

```
https://cdntx.moecube.com/ygopro-genesys/lflist.conf
```
