import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { AragamiModule } from 'nestjs-aragami';
import { MycardAuthModule } from 'nestjs-mycard';

@Module({
  imports: [
    ConfigModule.forRoot({
      load: [loadConfig],
      isGlobal: true,
      ignoreEnvVars: true,
      ignoreEnvFile: true,
    }),
    AragamiModule.registerAsync({
      inject: [ConfigService],
      useFactory: (configService: ConfigService) => {
        const uri = configService.get<string>('REDIS_URI');
        return {
          redis: uri ? { uri } : undefined,
        };
      },
    }),
    MycardAuthModule.registerAsync({
      inject: [ConfigService],
      useFactory: (configService: ConfigService) => ({
        accountUrl: configService.get<string>('ACCOUNT_URL'),
      }),
    }),
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
