import yaml from 'yaml';
import * as fs from 'fs';

const defaultConfig = {
  host: '::',
  port: 3000,
  REDIS_URI: '',
  ACCOUNT_URL: 'https://sapi.moecube.com:444/accounts',
  MAX_SERVER_COUNT: 5,
};
export type Config = typeof defaultConfig;

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
    ...process.env,
  };
}
