#!/bin/sh
set -e

if [ -n "$EXTRA_PACKAGES" ]; then
    echo "Installing extra packages: $EXTRA_PACKAGES"
    apk add $EXTRA_PACKAGES
fi

if [ -n "$BEFORE_SCRIPT" ]; then
    echo "Running before script: $BEFORE_SCRIPT"
    sh -c "$BEFORE_SCRIPT"
fi

if [ -n "$IMMEDIATE" ]; then
  echo "Running $@ immediately..."
  "$@"
fi

echo "Will run $@ in $SCHEDULE"
/usr/local/bin/go-cron "$SCHEDULE" "$@"
