// Copyright (C) 2002-2007 Nikolaus Gebhardt
// This file is part of the "Irrlicht Engine".
// For conditions of distribution and use, see copyright notice in irrlicht.h
// 
// I (Nikolaus Gebhardt) did some few changes to Jonas Petersen's original loader:
// - removed setTexturePath() and replaced with the ISceneManager::getStringParameter()-stuff. 
// - added EAMT_LMTS enumeration value
// Thanks a lot to Jonas Petersen for his work 
// on this and that he gave me his permission to add it into Irrlicht. 
/*

CLMTSMeshFileLoader.h

LMTSMeshFileLoader
Written by Jonas Petersen (a.k.a. jox)

Version 1.5 - 15 March 2005

*/

// set this to 1 if you want to integrate the loader directly into the engine
#define LMTS_INTEGRATED_IN_IRRLICHT 1



#if !defined(__C_LMTS_MESH_FILE_LOADER_H_INCLUDED__)
#define __C_LMTS_MESH_FILE_LOADER_H_INCLUDED__

#if LMTS_INTEGRATED_IN_IRRLICHT
#define LMTS_LOG os::Printer::log
#else
#define LMTS_LOG Logger->log
#endif

#ifdef _MSC_VER
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#endif

#include <IMeshLoader.h>
#include <SMesh.h>
#include <IFileSystem.h>
#include <IVideoDriver.h>

#if !LMTS_INTEGRATED_IN_IRRLICHT
#include <ILogger.h>
#endif

namespace irr
{
namespace scene
{

class CLMTSMeshFileLoader : public IMeshLoader
{
public:

#if LMTS_INTEGRATED_IN_IRRLICHT
	CLMTSMeshFileLoader(io::IFileSystem* fs, 
		video::IVideoDriver* driver, io::IAttributes* parameters);
#else
	CLMTSMeshFileLoader(IrrlichtDevice* device);
#endif

	virtual ~CLMTSMeshFileLoader();

	void cleanup();

	virtual bool isALoadableFileExtension(const c8* fileName);

	virtual IAnimatedMesh* createMesh(irr::io::IReadFile* file);
	
private:
	void constructMesh();
	void loadTextures();


// byte-align structures
#if defined(_MSC_VER) ||  defined(__BORLANDC__) || defined (__BCPLUSPLUS__) 
#	pragma pack( push, packing )
#	pragma pack( 1 )
#	define PACK_STRUCT
#elif defined( __GNUC__ )
#	define PACK_STRUCT	__attribute__((packed))
#else
#	error compiler not supported
#endif


	struct SLMTSMagigID {
		u32 ID;
	} PACK_STRUCT;

	struct SLMTSHeader
	{
		u32 MagicID;
		u32 Version;
		u32 HeaderSize;
		u16 TextureCount;
		u16 SubsetCount;
		u32 TriangleCount;
		u16 SubsetSize;
		u16 VertexSize;
	} PACK_STRUCT;

	struct SLMTSTextureInfoEntry
	{
		c8 Filename[256];
		u16 Flags;
	} PACK_STRUCT;

	struct SLMTSSubsetInfoEntry
	{
		u32 Offset;
		u32 Count;
		u16 TextID1;
		u16 TextID2;
	} PACK_STRUCT;

	struct SLMTSTriangleDataEntry
	{
		f32 X;
		f32 Y;
		f32 Z;
		f32 U1;
		f32 V1;
		f32 U2;
		f32 V2;
	} PACK_STRUCT;

// Default alignment
#if defined(_MSC_VER) ||  defined(__BORLANDC__) || defined (__BCPLUSPLUS__) 
#	pragma pack( pop, packing )
#endif

#undef PACK_STRUCT

	SLMTSHeader Header;
	SLMTSTextureInfoEntry* Textures;
	u16* TextureIDs;
	SLMTSSubsetInfoEntry* Subsets;
	SLMTSTriangleDataEntry* Triangles;

	scene::SMesh* Mesh;
	s32 NumTextures;
	s32 NumLightMaps;

	io::IAttributes* Parameters;
	video::IVideoDriver* Driver;
	io::IFileSystem* FileSystem;

#if !LMTS_INTEGRATED_IN_IRRLICHT
	ILogger* Logger;
#endif
};

} // end namespace scene
} // end namespace irr

#endif // !defined(__C_LMTS_MESH_FILE_LOADER_H_INCLUDED__)
