import { Column, Entity, Index, ManyToOne } from 'typeorm';
import { BasePlayer } from './BasePlayer';
import { DuelLog } from './DuelLog';

@Entity()
export class DuelLogPlayer extends BasePlayer {
  @Index()
  @Column({ type: 'varchar', length: 20 })
  realName: string;

  @Column({ type: 'varchar', length: 64, nullable: true })
  ip: string;

  @Column('tinyint', { unsigned: true })
  isFirst: number;

  @Index()
  @Column('tinyint')
  score: number;

  @Column('int', { nullable: true })
  lp: number;

  @Column('smallint', { nullable: true })
  cardCount: number;

  @Column('text', { nullable: true })
  startDeckBuffer: string;

  @Column('text', { nullable: true })
  currentDeckBuffer: string;

  @Column('tinyint')
  winner: number;

  @ManyToOne(() => DuelLog, (duelLog) => duelLog.players)
  duelLog: DuelLog;
}
