import {
  Column,
  Entity,
  Index,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';
import { DuelLogPlayer } from './DuelLogPlayer';
import { CreateAndUpdateTimeBase } from './CreateAndUpdateTimeBase';

@Entity({
  orderBy: {
    id: 'DESC',
  },
})
export class DuelLog extends CreateAndUpdateTimeBase {
  @PrimaryGeneratedColumn({
    unsigned: true,
    type: 'bigint',
  })
  id: number;

  @Index()
  @Column('datetime')
  time: Date;

  @Index()
  @Column({ type: 'varchar', length: 20 })
  name: string;

  @Column('int')
  roomId: number;

  @Column('bigint')
  cloudReplayId: number; // not very needed to become a relation

  @Column({ type: 'varchar', length: 256 })
  replayFileName: string;

  @Column('tinyint', { unsigned: true })
  roomMode: number;

  @Index()
  @Column('tinyint', { unsigned: true })
  duelCount: number;

  @OneToMany(() => DuelLogPlayer, (player) => player.duelLog)
  players: DuelLogPlayer[];
}
