import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { DuelLogPlayer } from './entities/DuelLogPlayer';
import { DuelLog } from './entities/DuelLog';

@Module({
  imports: [
    ConfigModule.forRoot({
      load: [loadConfig],
      isGlobal: true,
      ignoreEnvVars: true,
      ignoreEnvFile: true,
    }),
    TypeOrmModule.forRootAsync({
      inject: [ConfigService],
      useFactory: async (config: ConfigService) => ({
        type: 'mysql',
        entities: [],
        autoLoadEntities: true,
        synchronize: false,
        host: config.get('DB_HOST'),
        port: parseInt(config.get('DB_PORT')) || 3306,
        username: config.get('DB_USER'),
        password: config.get('DB_PASS'),
        database: config.get('DB_NAME'),
        supportBigNumbers: true,
        bigNumberStrings: false,
      }),
    }),
    TypeOrmModule.forFeature([DuelLogPlayer, DuelLog]),
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
