import { Controller, Get, Param } from '@nestjs/common';
import { AppService } from './app.service';
import { ApiOkResponse, ApiOperation, ApiParam } from '@nestjs/swagger';
import { ReturnMessageDto } from 'nicot';
import { MatchResultDto } from './dto/match-result.dto';

class MatchResultReturnMessageDto extends ReturnMessageDto(MatchResultDto) {}

@Controller()
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('dealer')
  @ApiOperation({
    summary: '发牌姬的对局统计',
  })
  @ApiOkResponse({
    type: MatchResultReturnMessageDto,
  })
  async getDealerMatchResult() {
    return await this.appService.getDealerMatchResult();
  }

  @Get('user/:username')
  @ApiOperation({
    summary: '用户的对局统计',
  })
  @ApiParam({
    name: 'username',
    description: '用户名',
  })
  @ApiOkResponse({
    type: MatchResultReturnMessageDto,
  })
  async getUserMatchResult(@Param('username') username: string) {
    return await this.appService.getUserMatchResult(username);
  }
}
