import { Entity, Index, ManyToOne, PrimaryColumn } from 'typeorm';
import { Archive } from './Archive.entity';

@Entity()
export class ArchiveFile {
  @ManyToOne(() => Archive, (a) => a.containingFiles, { primary: true, onDelete: 'CASCADE' })
  archive: Archive;

  @Index()
  @PrimaryColumn('varchar', { length: 256 })
  path: string;

  static fromPath(path: string) {
    const archiveFile = new ArchiveFile();
    archiveFile.path = path;
    return archiveFile;
  }
}
