import { Body, Controller, Get, Header, Param, ParseArrayPipe, Post, Query, Render, ValidationPipe } from '@nestjs/common';
import { UpdateService } from './update.service';
import { ApiBody, ApiOkResponse, ApiOperation, ApiParam, ApiProperty, ApiQuery, ApiTags } from '@nestjs/swagger';
import { DepotDto } from '../dto/Depot.dto';

@Controller('update')
@ApiTags('update')
export class UpdateController {
  constructor(private readonly updateService: UpdateService) {}
  @Get('apps.json')
  @ApiOperation({ summary: '获取 apps.json', description: '懒得解释这是啥了……' })
  @Header('Cache-Control', 'public, max-age=600, stale-while-revalidate=600, stale-if-error=604800')
  getAppsJson() {
    return this.updateService.getAppsJson();
  }

  @Get('checksums/:id/:version')
  @Render('checksums')
  @ApiOperation({ summary: '获取 app 校验和', description: '是 shasum 的格式' })
  @ApiParam({ name: 'id', description: 'APP 的 id' })
  @ApiParam({ name: 'version', description: 'APP 的版本号' })
  @ApiQuery({ type: DepotDto, description: 'APP 的类型' })
  @ApiOkResponse({ type: String })
  @Header('Cache-Control', 'public, max-age=31536000, immutable')
  async getChecksum(
    @Param('id') id: string,
    @Query(new ValidationPipe({ transform: true })) depot: DepotDto,
    @Param('version') version: string
  ) {
    return this.updateService.getChecksum(id, depot, version);
  }

  @Get('metalinks/:id/:version')
  @Render('metalinks')
  @ApiOperation({ summary: '获取 app 完整包 metalink', description: '只包含完整包的' })
  @ApiParam({ name: 'id', description: 'APP 的 id' })
  @ApiParam({ name: 'version', description: 'APP 的版本号' })
  @ApiQuery({ type: DepotDto, description: 'APP 的类型' })
  @ApiOkResponse({ type: String })
  @Header('Cache-Control', 'public, max-age=31536000, immutable')
  async getFullPackageMetalink(
    @Param('id') id: string,
    @Query(new ValidationPipe({ transform: true })) depot: DepotDto,
    @Param('version') version: string
  ) {
    return this.updateService.getFullPackageMetalink(id, depot, version);
  }

  @Post('update/:id/:version')
  @Render('metalinks')
  @ApiOperation({ summary: '获取 app 部分包 metalink', description: '根据文件返回需要下载什么文件' })
  @ApiParam({ name: 'id', description: 'APP 的 id' })
  @ApiParam({ name: 'version', description: 'APP 的版本号' })
  @ApiQuery({ type: DepotDto, description: 'APP 的类型' })
  @ApiBody({ type: [String], description: '需要什么文件' })
  @ApiOkResponse({ type: String })
  async getPartPackageMetalink(
    @Param('id') id: string,
    @Query(new ValidationPipe({ transform: true })) depot: DepotDto,
    @Param('version') version: string,
    @Body(new ParseArrayPipe()) requestedFiles: string[]
  ) {
    //return requestedFiles;
    return this.updateService.getPartPackageMetalink(id, depot, version, requestedFiles);
  }
}
