import { Column, Entity, ManyToOne, OneToMany, PrimaryGeneratedColumn, Unique } from 'typeorm';
import { Depot } from './Depot.entity';
import { Archive } from './Archive.entity';
import { Index } from 'typeorm';
import { TimeBase } from './TimeBase.entity';

@Entity()
@Index((b) => [b.depot, b.version])
export class Build extends TimeBase {
  @PrimaryGeneratedColumn()
  id: number;

  @Index()
  @Column()
  version: string;

  @ManyToOne(() => Depot, (depot) => depot.builds)
  depot: Depot;

  @OneToMany(() => Archive, (archive) => archive.build, { cascade: true })
  archives: Archive[];

  @Column({ type: 'hstore', hstoreType: 'object' })
  checksum: Record<string, string>;
}
