import { AppsJson } from '../utility/apps-json-type';
import Platform = AppsJson.Platform;
import Locale = AppsJson.Locale;
import { ApiParam, ApiProperty } from '@nestjs/swagger';
import { Brackets, SelectQueryBuilder } from 'typeorm';

export interface DepotLike {
  platform?: string;
  arch?: string;
  locale?: string;
}

export class DepotDto implements DepotLike {
  @ApiProperty({ description: 'APP 的平台', enum: AppsJson.Platform })
  platform?: string;
  @ApiProperty({ description: 'APP 的 arch' })
  arch?: string;
  @ApiProperty({ description: 'APP 的语言', enum: AppsJson.Locale })
  locale?: string;
  get toActual(): DepotLike {
    return {
      platform: this.platform || 'generic',
      arch: this.arch || 'generic',
      locale: this.locale || 'generic',
    };
  }

  getFieldQueryBrackets(field: keyof DepotLike) {
    const value = this[field];
    if (!value || value === 'generic') {
      return new Brackets((qb) => {
        qb.where(`build.${field} = 'generic'`);
      });
    } else {
      return new Brackets((qb) => {
        qb.where(`build.${field} = 'generic'`).orWhere(`build.${field} = :${field}`, { [field]: value });
      });
    }
  }

  getQueryBrackets() {
    return new Brackets((qb) => {
      qb.where(this.getFieldQueryBrackets('platform'))
        .andWhere(this.getFieldQueryBrackets('arch'))
        .andWhere(this.getFieldQueryBrackets('locale'));
    });
  }
}
