import { Controller, Get, Param, Query, Render, ValidationPipe } from '@nestjs/common';
import { UpdateService } from './update.service';
import { ApiOkResponse, ApiOperation, ApiParam, ApiProperty, ApiQuery, ApiTags } from '@nestjs/swagger';
import { DepotDto } from '../dto/Depot.dto';

@Controller('update')
@ApiTags('update')
export class UpdateController {
  constructor(private readonly updateService: UpdateService) {}
  @Get('apps.json')
  @ApiOperation({ summary: '获取 apps.json', description: '懒得解释这是啥了……' })
  getAppsJson() {
    return this.updateService.getAppsJson();
  }

  @Get('checksums/:id/:version')
  @Render('checksums')
  @ApiOperation({ summary: '获取 app 校验和', description: '是 shasum 的格式' })
  @ApiParam({ name: 'id', description: 'APP 的 id' })
  @ApiParam({ name: 'version', description: 'APP 的版本号' })
  @ApiQuery({ type: DepotDto, description: 'APP 的类型' })
  @ApiOkResponse({ type: String })
  async getChecksum(
    @Param('id') id: string,
    @Query(new ValidationPipe({ transform: true })) depot: DepotDto,
    @Param('version') version: string
  ) {
    return this.updateService.getChecksum(id, depot, version);
  }

  @Get('metalinks/:id/:version')
  @Render('metalinks')
  @ApiOperation({ summary: '获取 app 完整包 metalink', description: '只包含完整包的' })
  @ApiParam({ name: 'id', description: 'APP 的 id' })
  @ApiParam({ name: 'version', description: 'APP 的版本号' })
  @ApiQuery({ type: DepotDto, description: 'APP 的类型' })
  @ApiOkResponse({ type: String })
  async getFullPackageMetalink(
    @Param('id') id: string,
    @Query(new ValidationPipe({ transform: true })) depot: DepotDto,
    @Param('version') version: string
  ) {
    return this.updateService.getFullPackageMetalink(id, depot, version);
  }
}
