import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';
import { Build } from './Build.entity';
import { Index } from 'typeorm';
import { TimeBase } from './TimeBase.entity';

export enum ArchiveType {
  Full = 'full',
  Update = 'update',
  Part = 'part',
}

@Entity()
export class Archive extends TimeBase {
  @PrimaryGeneratedColumn()
  id: number;

  @Column('varchar', { length: 256, array: true })
  files: string[];

  @Index()
  @Column('varchar', { length: 128 })
  path: string;

  @Column('int', { unsigned: true })
  size: number;

  @ManyToOne((type) => Build, (build) => build.archives)
  build: Build;

  @Column({ type: 'enum', enum: ArchiveType })
  role: ArchiveType;

  get archiveFullPath() {
    return `${this.path}.tar.gz`;
  }

  toMetalinkView() {
    return {
      name: this.archiveFullPath,
    };
  }
}
