import { Column, Entity, Index, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';
import { AppBase } from './AppBase.entity';
import { App } from './App.entity';

@Entity({ orderBy: { time: 'DESC' } })
export class AppHistory extends AppBase {
  @PrimaryGeneratedColumn()
  id: number;

  @Index()
  @Column()
  time: Date;

  @Index()
  @Column({ nullable: true })
  operatingUser: number;

  @ManyToOne(() => App, (a) => a.history)
  parentApp: App;
}
