import { Column, Entity, Index, ManyToOne, OneToMany, PrimaryGeneratedColumn } from 'typeorm';
import { App } from './App.entity';
import { Build } from './Build.entity';

@Index((d) => [d.app, d.locale, d.platform.d.arch], { unique: true })
@Entity()
export class Depot {
  @PrimaryGeneratedColumn()
  id: number;

  @Index()
  @Column({ default: 'generic' })
  locale: string;

  @Index()
  @Column({ default: 'generic' })
  platform: string;

  @Index()
  @Column({ default: 'generic' })
  arch: string;

  @ManyToOne((type) => App, (app) => app.depots)
  app: App;

  @OneToMany(() => Build, (build) => build.depot)
  builds: Build[];
}
