import { Column, Entity, ManyToOne, OneToMany, PrimaryGeneratedColumn } from 'typeorm';
import { Depot } from './Depot.entity';
import { Archive } from './Archive.entity';
import { Index } from 'typeorm/browser';

@Entity()
export class Build {
  @PrimaryGeneratedColumn()
  id: number;

  @Index()
  @Column()
  version: string;

  @ManyToOne((type) => Depot, (depot) => depot.builds)
  depot: Depot;

  @OneToMany((type) => Archive, (archive) => archive.build)
  archives: Archive[];

  @Column({ type: 'hstore', hstoreType: 'object' })
  checksum: Record<string, string>;
}
