import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';
import { Build } from './Build.entity';
import { Index } from 'typeorm/browser';

export enum ArchiveType {
  Full = 'full',
  Update = 'update',
  Part = 'part',
}

@Entity()
export class Archive {
  @PrimaryGeneratedColumn()
  id: number;

  @Column('varchar', { length: 256, array: true })
  files: string[];

  @Index()
  @Column('varchar', { length: 140 })
  path: string;

  @ManyToOne((type) => Build, (build) => build.archives)
  build: Build;

  @Column({ type: 'enum', enum: ArchiveType })
  role: ArchiveType;
}
