import { Column, Entity, Index, OneToMany, PrimaryColumn } from 'typeorm';
import { AppsJson } from '../utility/apps-json-type';
import { MyCardUser } from '../utility/mycard-auth';
import { AppBase } from './AppBase.entity';
import { AppHistory } from './AppHistory.entity';
import moment from 'moment';
import { join } from 'path';
import { Depot } from './Depot.entity';

@Entity()
export class App extends AppBase {
  @PrimaryColumn('varchar', { length: 64 })
  id: string;

  @Index()
  @Column('int', { nullable: true, array: true })
  author: number[];

  @Column({ nullable: true, select: false })
  isDeleted: boolean;

  @Column('varchar', { length: 128, nullable: true })
  packagePrefix: string;

  @OneToMany(() => Depot, depot => depot.app)
  depots: Depot[];

  get packageFullPath() {
    if (this.packagePrefix && this.packagePrefix.length) {
      return join(this.id, this.packagePrefix);
    } else {
      return this.id;
    }
  }

  isUserCanEditApp(u: MyCardUser) {
    return u.admin || (this.author && this.author.includes(u.id));
  }

  @OneToMany(() => AppHistory, (h) => h.parentApp, { cascade: true })
  history: AppHistory[];

  updateApp(appData: AppsJson.App, changeUser?: number) {
    appData.updated_at = moment().format('YYYY-MM-DD HH:mm:ss');
    this.appData = appData;
    const h = new AppHistory();
    h.parentApp = this;
    h.time = new Date();
    if (changeUser) {
      h.operatingUser = changeUser;
    }
    h.appData = appData;
    this.history.push(h);
  }
}
