/**
 * Created by weijian on 2016/12/29.
 */
/// <reference types="mongodb" />
import * as mongodb from "mongodb";

declare module Mongorito {
    function connect(url: string): Promise<mongodb.Db>

    function setDriver(driver: any);

    function getDriver(): any;

    interface Options {
        [skip: string]: string|string[];
    }

    class Model {
        constructor(o: any, options?: Object);

        get(key: string): any;

        set(key: string, value: Object);

        unset(key: string);

        toJSON();

        before(action: string, method: Function);
        before(action: string, method: Function[]);
        before(action: string, method: string);
        before(action: string, method: string[]);

        after(action: string, method: Function);
        after(action: string, method: Function[]);
        after(action: string, method: string);
        after(action: string, method: string[]);

        around(action: string, method: Function);
        around(action: string, method: Function[]);
        around(action: string, method: string);
        around(action: string, method: string[]);

        /**
         * Configure model (usually, set hooks here)
         * Supposed to be overriden
         *
         * @api public
         */
        configure();

        /**
         * Save a model
         *
         * @param {Object} options - options for save operation
         * @api public
         */
        save(options?: Options): Promise<any>;

        /**
         * Create a model
         *
         * @api private
         */

        create(options?: Options): Promise<any>;

        update(options?: Options): Promise<any>;

        remove(options?: Options): Promise<any>;

        /**
         * Atomically increment a model property
         *
         * @param {Object} props - set of properties and values
         * @param {Object} options - options for update operation
         * @api public
         */

        inc(props: Object, options: Options);


        /**
         * Find documents
         *
         * @param {Object} query - find conditions, same as this.where()
         * @api public
         */
        static find(query: Object): Promise<any[]>;

        /**
         * Count documents
         *
         * @param {Object} query - find conditions, same as this.where()
         * @api public
         */
        static count(query: Object): Promise<any>;

        /**
         * Get distinct
         *
         * @param {String} field for distinct
         * @param {Object} query - query to filter the results
         * @see http://mongodb.github.io/node-mongodb-native/2.0/api/Collection.html#distinct
         * @api public
         */
        static distinct(filed: string, query?: Object): Promise<any>;

        /**
         * Aggregation query
         *
         * @param {String} pipeline aggregation pipeline
         * @param {Object} options - Options to be passed to aggregation pipeline
         * @see http://mongodb.github.io/node-mongodb-native/2.0/api/Collection.html#distinct
         * @api public
         */
        static aggregate(pipeline: Object[]): Promise<any>;

        /**
         * Find all documents in a collection
         *
         * @api public
         */
        static all(): Promise<any[]>

        /**
         * Find one document
         *
         * @param {Object} query - find conditions, same as this.where()
         * @api public
         */
        static findOne(query: Object): Promise<any>;

        /**
         * Find a document by ID
         *
         * @param {ObjectID} id - document id
         * @api public
         */
        static findById(id: string): Promise<any>;

        /**
         * Remove documents
         *
         * @param {Object} query - remove conditions, same as this.where()
         * @api public
         */
        static remove(query: Object): Promise<any>;

        /**
         * Drop collection
         *
         * @api public
         */
        static drop(): Promise<any>;

    }
}
export=Mongorito
