import { CanActivate, ExecutionContext, Injectable } from '@nestjs/common';
import { getUserFromContext } from './utility/mycard-auth';
import { BlankReturnMessageDto } from './dto/ReturnMessage.dto';

@Injectable()
export class MyCardAdminGuard implements CanActivate {
  async canActivate(context: ExecutionContext): Promise<boolean> {
    const user = await getUserFromContext(context);
    if (!user) {
      throw new BlankReturnMessageDto(401, 'Invalid user').toException();
    }
    if (!user.admin) {
      throw new BlankReturnMessageDto(403, 'Permission denied').toException();
    }
    return true;
  }
}
