import { TimeBase } from './TimeBase.entity';
import { Column } from 'typeorm';
import { AppsJson } from '../utility/apps-json-type';

export class AppBase extends TimeBase {
  @Column('jsonb', { nullable: true })
  appData: AppsJson.App;

  get displayData() {
    if (!this.appData) {
      return null;
    }
    if (!this.appData.actions) {
      this.appData.actions = {};
    }
    for (const field of Object.values(AppsJson.Platform)) {
      if (!this.appData.actions[field]) {
        this.appData.actions[field] = {};
      }
    }
    return this.appData;
  }
}
