import { CreateDateColumn, UpdateDateColumn } from 'typeorm';
import { Exclude } from 'class-transformer';

export class TimeBase {
  @CreateDateColumn({ select: false })
  @Exclude()
  createTime: Date;

  @UpdateDateColumn({ select: false })
  @Exclude()
  updateTime: Date;

  toObject() {
    return JSON.parse(JSON.stringify(this));
  }
}
