import { Column, Entity, Index, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';
import { Build } from './Build.entity';
import { TimeBase } from './TimeBase.entity';
import { ArchiveMirror } from './ArchiveMirror.entity';

export enum ArchiveType {
  Full = 'full',
  Update = 'update',
  Part = 'part',
}

@Entity()
export class Archive extends TimeBase {
  @PrimaryGeneratedColumn({ type: 'int8' })
  id: number;

  @Column('varchar', { length: 256, array: true, default: [] })
  files: string[];

  //@OneToMany(() => ArchiveFile, (file) => file.archive, { cascade: true })
  //containingFiles: ArchiveFile[];

  @Index()
  @Column('varchar', { length: 128 })
  path: string;

  @Column('varchar', { length: 64, nullable: true })
  hash: string;

  @Column('int', { unsigned: true })
  size: number;

  @ManyToOne((type) => Build, (build) => build.archives, { onDelete: 'CASCADE' })
  build: Build;

  @Index()
  @Column({ type: 'enum', enum: ArchiveType })
  role: ArchiveType;

  // should not be a relation
  mirrors: ArchiveMirror[];

  get archiveFullPath() {
    return `${this.path}.tar.zst`;
  }

  getParamSize() {
    return 5 + (this.files?.length || 0);
  }

  toMetalinkView() {
    return {
      name: this.archiveFullPath,
    };
  }
}
