import { Injectable } from '@nestjs/common';
// import { Redlock } from '@sesamecare-oss/redlock';
import { ConfigService } from '@nestjs/config';
import Redis from 'ioredis';

class Redlock {
  constructor(private redis: any[]) {}

  async quit() {}

  async using(...args: any[]) {}
}

@Injectable()
export class LockService {
  constructor(private config: ConfigService) {}

  createRedisClient() {
    const url = this.config.get<string>('REDIS_URL');
    return new Redis(url);
  }

  getLockInstance() {
    const redis = this.createRedisClient();
    return new Redlock([redis]);
  }

  async useTmpRedisClient<T>(cb: (redis: Redis.Redis) => Promise<T>) {
    const redis = this.createRedisClient();
    try {
      return await cb(redis);
    } finally {
      await redis.quit();
    }
  }

  async useTmpLockInstance<T>(cb: (lock: Redlock) => Promise<T>) {
    const lock = this.getLockInstance();
    try {
      return await cb(lock);
    } finally {
      await lock.quit();
    }
  }

  async using<T>(key: string[], timeout: number, cb: () => Promise<T>) {
    return this.useTmpLockInstance(async (lock) => {
      return await lock.using(key, timeout, cb);
    });
  }
}
