import { AppsJson } from '../utility/apps-json-type';
import { ApiProperty } from '@nestjs/swagger';
import { Brackets } from 'typeorm';

export interface DepotLike {
  platform?: string;
  arch?: string;
  locale?: string;
}

export class DepotDto implements DepotLike {
  @ApiProperty({ description: 'APP 的平台', enum: AppsJson.Platform })
  platform?: string;
  @ApiProperty({ description: 'APP 的 arch' })
  arch?: string;
  @ApiProperty({ description: 'APP 的语言', enum: AppsJson.Locale })
  locale?: string;
  get toActual(): DepotLike {
    return {
      platform: this.platform || 'generic',
      arch: this.arch || 'generic',
      locale: this.locale || 'generic',
    };
  }

  getFieldQueryBrackets(field: keyof DepotLike) {
    const value = this[field];
    if (!value || value === 'generic') {
      return new Brackets((qb) => {
        qb.where(`depot.${field} = 'generic'`);
      });
    } else {
      return new Brackets((qb) => {
        qb.where(`depot.${field} = 'generic'`).orWhere(`depot.${field} = :${field}`, { [field]: value });
      });
    }
  }

  getQueryBrackets() {
    return new Brackets((qb) => {
      qb.where(this.getFieldQueryBrackets('platform'))
        .andWhere(this.getFieldQueryBrackets('arch'))
        .andWhere(this.getFieldQueryBrackets('locale'));
    });
  }
}

export class MakeBuildDto extends DepotDto { 
  @ApiProperty({ description: '是否强制重新打包', required: false })
  force?: boolean;
}
