import { ApiProperty } from '@nestjs/swagger';
import { HttpException } from '@nestjs/common';
import { AppsJson } from '../utility/apps-json-type';
import { Build } from '../entities/Build.entity';

export class BlankReturnMessageDto {
  @ApiProperty({ description: '返回状态' })
  statusCode: number;
  @ApiProperty({ description: '返回信息' })
  message: string;
  @ApiProperty({ description: '是否成功' })
  success: boolean;
  constructor(statusCode: number, message?: string) {
    this.statusCode = statusCode;
    this.message = message || 'success';
    this.success = statusCode < 400;
  }

  toException() {
    return new HttpException(this, this.statusCode);
  }
}

export class ReturnMessageDto<T> extends BlankReturnMessageDto {
  @ApiProperty({ description: '返回内容' })
  data?: T;
  constructor(statusCode: number, message?: string, data?: T) {
    super(statusCode, message);
    this.data = data;
  }
}

export class GetAppReturnMessageDto extends BlankReturnMessageDto {
  @ApiProperty({ description: '返回 app' })
  data?: AppsJson.AppClass;
}

export class UploadAssignInfo {
  @ApiProperty({ description: '下载地址' })
  downloadUrl: string;
  @ApiProperty({ description: 's3 上传地址，如果是空则不需要上传' })
  uploadUrl?: string;

  constructor(downloadUrl: string, uploadurl?: string) {
    this.downloadUrl = downloadUrl;
    this.uploadUrl = uploadurl;
  }
}

export class StringReturnMessageDto extends BlankReturnMessageDto {
  @ApiProperty({ description: '返回字符串' })
  data?: string;
}

export class UploadAssignInfoReturnMessageDto extends BlankReturnMessageDto {
  @ApiProperty({ description: '返回内容' })
  data?: UploadAssignInfo;
}

export class BuildReturnMessageDto extends BlankReturnMessageDto {
  @ApiProperty({ description: '返回内容' })
  data?: Build;
}
