import { TimeBase } from './TimeBase.entity';
import { Column } from 'typeorm';
import { AppsJson } from '../utility/apps-json-type';
import { MyCardUser } from '../utility/mycard-auth';

export class AppBase extends TimeBase {
  @Column('text', { nullable: true })
  appContent: string;

  get appData(): AppsJson.App {
    if (!this.appContent) {
      return null;
    }
    const a = JSON.parse(this.appContent);
    return a;
  }

  set appData(a) {
    this.appContent = JSON.stringify(a);
  }
}
