import { Column, Entity, Index, OneToMany, PrimaryColumn } from 'typeorm';
import { AppsJson } from '../utility/apps-json-type';
import { MyCardUser } from '../utility/mycard-auth';
import { AppBase } from './AppBase.entity';
import { AppHistory } from './AppHistory.entity';
import moment from 'moment';

@Entity()
export class App extends AppBase {
  @PrimaryColumn('varchar', { length: 64 })
  id: string;

  @Index()
  @Column('int', { nullable: true, array: true })
  author: number[];

  @Column({ nullable: true, select: false })
  isDeleted: boolean;

  isUserCanEditApp(u: MyCardUser) {
    return u.admin || (this.author && this.author.includes(u.id));
  }

  @OneToMany(() => AppHistory, (h) => h.parentApp, { cascade: true })
  history: AppHistory[];

  updateApp(appData: AppsJson.App, changeUser?: number) {
    appData.updated_at = moment().format('YYYY-MM-DD HH:mm:ss');
    this.appData = appData;
    const h = new AppHistory();
    h.parentApp = this;
    h.time = new Date();
    if (changeUser) {
      h.operatingUser = changeUser;
    }
    h.appData = appData;
    this.history.push(h);
  }

  get appData(): AppsJson.App {
    const appData = super.appData;
    appData.id = this.id;
    return appData;
  }

  set appData(a) {
    this.appContent = JSON.stringify(a);
  }
}
