import { TypeOrmModuleOptions } from '@nestjs/typeorm';
import { App } from './entities/App.entity';
import { AppHistory } from './entities/AppHistory.entity';

export function dbConfig() {
  return {
    host: process.env.DB_HOST,
    port: process.env.DB_PORT ? parseInt(process.env.DB_PORT) : 5432,
    username: process.env.DB_USER,
    password: process.env.DB_PASS,
    database: process.env.DB_NAME,
  };
}
export function typeormConfig(): TypeOrmModuleOptions {
  return {
    name: 'app',
    type: 'postgres',
    entities: [App, AppHistory], // entities here
    synchronize: true,
    ...dbConfig(),
  };
}
