import {
  Body,
  Controller,
  Get,
  ParseIntPipe,
  Post,
  Query,
  ValidationPipe,
} from '@nestjs/common';
import { AppService } from './app.service';
import {
  ApiBody,
  ApiCreatedResponse,
  ApiOkResponse,
  ApiOperation,
  ApiQuery,
} from '@nestjs/swagger';
import {
  BlankReturnMessageDto,
  GetAppReturnMessageDto,
} from './dto/ReturnMessage.dto';
import { FetchMyCardUser, MyCardUser } from './utility/mycard-auth';
import { AppsJson } from './utility/apps-json-type';
import AppClass = AppsJson.AppClass;

@Controller('api')
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('apps.json')
  getAppsJson() {
    return this.appService.getAppsJson();
  }

  @Get('app')
  @ApiOperation({
    summary: '获取 app',
    description: '管理员可以查询全部的，其他用户可以查属于自己的',
  })
  @ApiQuery({ name: 'id', description: 'app 的 id，没有就是查全部' })
  @ApiOkResponse({ type: GetAppReturnMessageDto })
  getApp(@FetchMyCardUser() user: MyCardUser, @Query('id') id?: string) {
    return this.appService.getApp(user, id);
  }

  @Post('app')
  @ApiOperation({
    summary: '更新 app',
  })
  @ApiBody({ type: AppsJson.AppClass })
  @ApiCreatedResponse({ type: BlankReturnMessageDto })
  updateApp(
    @FetchMyCardUser() user: MyCardUser,
    @Body(new ValidationPipe({ transform: true })) app: AppClass,
  ) {
    return this.appService.updateApp(user, app.id, app);
  }
}
