import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AdminController } from './admin/admin.controller';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { App } from './entities/App.entity';
import { AppHistory } from './entities/AppHistory.entity';
import { PackagerService } from './packager/packager.service';
import { AssetsS3Service } from './assets-s3/assets-s3.service';
import { PackageS3Service } from './package-s3/package-s3.service';
import { Archive } from './entities/Archive.entity';
import { Build } from './entities/Build.entity';
import { Depot } from './entities/Depot.entity';
import { UpdateController } from './update/update.controller';
import { UpdateService } from './update/update.service';
import { ServeStaticModule } from '@nestjs/serve-static';
import path from 'path';
import { ArchiveMirror } from './entities/ArchiveMirror.dto';
import { MirrorService } from './mirror/mirror.service';
import { HttpModule } from '@nestjs/axios';

const configModule = ConfigModule.forRoot();

@Module({
  imports: [
    ServeStaticModule.forRoot({
      rootPath: path.join(__dirname, '..', 'public'),
    }),
    configModule,
    HttpModule,
    TypeOrmModule.forRootAsync({
      name: 'app',
      imports: [configModule],
      inject: [ConfigService],
      useFactory: async (config: ConfigService) => {
        return {
          type: 'postgres',
          entities: [App, AppHistory, Archive, Build, Depot, ArchiveMirror], // entities here
          synchronize: !config.get('DB_NO_INIT'),
          host: config.get('DB_HOST'),
          port: parseInt(config.get('DB_PORT')) || 5432,
          username: config.get('DB_USER'),
          password: config.get('DB_PASS'),
          database: config.get('DB_NAME'),
          logging: !!config.get('DB_LOGGING'),
        };
      },
    }),
  ],
  controllers: [AppController, AdminController, UpdateController],
  providers: [AppService, PackagerService, AssetsS3Service, PackageS3Service, UpdateService, MirrorService],
})
export class AppModule {}
