import { Column, Entity, Index, ManyToOne, OneToMany, PrimaryGeneratedColumn } from 'typeorm';
import { Depot } from './Depot.entity';
import { Archive } from './Archive.entity';
import { TimeBase } from './TimeBase.entity';

@Entity()
@Index((b) => [b.depot, b.version])
export class Build extends TimeBase {
  @PrimaryGeneratedColumn()
  id: number;

  @Index()
  @Column()
  version: string;

  @ManyToOne(() => Depot, (depot) => depot.builds)
  depot: Depot;

  @OneToMany(() => Archive, (archive) => archive.build, { cascade: true })
  archives: Archive[];

  @Column({ type: 'hstore', hstoreType: 'object' })
  checksum: Record<string, string>;
}
