import { Column, Entity, Index, PrimaryColumn } from 'typeorm';
import { TimeBase } from './TimeBase.entity';

@Entity()
export class ArchiveMirror extends TimeBase {
  @PrimaryColumn('varchar', { length: 128 })
  @Index()
  path: string;

  @PrimaryColumn('varchar', { length: 64 })
  middleware: string;

  @Column('boolean', { default: false })
  disabled: boolean;

  @Column('varchar', { length: 10240 })
  url: string;
}
