import { AfterViewInit, Component } from '@angular/core';

import feather from 'feather-icons';
import { AppService, AppsJson } from './app/app.service';

@Component({
  selector: 'app-root',
  templateUrl: './mycard.component.html',
  styleUrls: ['./mycard.component.css'],
})
export class MyCardComponent implements AfterViewInit {
  title = 'console-web';

  apps = this.appService.apps;

  constructor(private appService: AppService) {}

  ngAfterViewInit(): void {
    feather.replace();
  }

  showName(app: AppsJson.App) {
    if (!app.name) return app.id;
    return app.name['zh-CN'];
  }
}
